<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CategoryGroupLightResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'slug' => $this->slug,
            'sub_groups_count' => $this->sub_groups_count,
            'active' => (bool) $this->active,
            'icon' => $this->icon,
            'icon_image' => $this->logoImage ? get_logo_url($this, 'full') : null
        ];
    }
}
